export interface Service {
  id: string;
  name: string;
  category: 'Exterior' | 'Interior' | 'Paint' | 'Protection' | 'Packages';
  price: string;
  duration: string;
  description: string;
  features: string[];
  popular: boolean;
  image?: string;
}

export const services: Service[] = [
  // Exterior Services
  {
    id: 'basic-wash',
    name: 'Basic Wash & Dry',
    category: 'Exterior',
    price: 'Starting at $29',
    duration: '30-45 min',
    description: 'Quick and thorough exterior wash to keep your vehicle clean.',
    features: [
      'Hand wash exterior',
      'Wheel and tire cleaning',
      'Window cleaning',
      'Hand dry with microfiber',
      'Tire dressing'
    ],
    popular: false,
    image: '/images/services/basic-wash.jpg'
  },
  {
    id: 'premium-wash',
    name: 'Premium Wash & Wax',
    category: 'Exterior',
    price: 'Starting at $49',
    duration: '60-90 min',
    description: 'Complete exterior wash with protective wax application.',
    features: [
      'Everything in Basic Wash',
      'Clay bar treatment',
      'Premium wax application',
      'Door jamb cleaning',
      'Chrome polishing'
    ],
    popular: true,
    image: '/images/services/premium-wash.jpg'
  },
  {
    id: 'paint-correction',
    name: 'Paint Correction',
    category: 'Paint',
    price: 'Starting at $299',
    duration: '4-6 hours',
    description: 'Multi-stage paint correction to restore your paint\'s original shine.',
    features: [
      'Paint decontamination',
      'Multi-stage machine polish',
      'Swirl and scratch removal',
      'Paint sealant application',
      'Before/after documentation'
    ],
    popular: false,
    image: '/images/services/paint-correction.jpg'
  },

  // Interior Services
  {
    id: 'interior-basic',
    name: 'Interior Basic Clean',
    category: 'Interior',
    price: 'Starting at $59',
    duration: '60-90 min',
    description: 'Thorough interior cleaning for a fresh cabin environment.',
    features: [
      'Complete vacuum',
      'Dashboard and console cleaning',
      'Window cleaning (inside)',
      'Floor mat cleaning',
      'Air freshener'
    ],
    popular: false,
    image: '/images/services/interior-basic.jpg'
  },
  {
    id: 'interior-deep',
    name: 'Interior Deep Clean',
    category: 'Interior',
    price: 'Starting at $149',
    duration: '3-4 hours',
    description: 'Deep cleaning and sanitization of your vehicle\'s interior.',
    features: [
      'Everything in Basic Clean',
      'Carpet shampooing',
      'Leather conditioning',
      'Steam cleaning',
      'Odor elimination treatment',
      'UV protection'
    ],
    popular: true,
    image: '/images/services/interior-deep.jpg'
  },

  // Protection Services
  {
    id: 'ceramic-coating',
    name: 'Ceramic Coating',
    category: 'Protection',
    price: 'Starting at $599',
    duration: '8-10 hours',
    description: 'Professional ceramic coating for ultimate paint protection.',
    features: [
      'Paint correction included',
      '3-5 year protection',
      'Hydrophobic coating',
      'UV protection',
      'Chemical resistance',
      'Warranty included'
    ],
    popular: true,
    image: '/images/services/ceramic-coating.jpg'
  },
  {
    id: 'ppf',
    name: 'Paint Protection Film',
    category: 'Protection',
    price: 'Starting at $799',
    duration: '1-2 days',
    description: 'Clear protective film to guard against rock chips and scratches.',
    features: [
      'Self-healing technology',
      '10-year warranty',
      'Custom computer cut',
      'Invisible protection',
      'Removable if needed'
    ],
    popular: false,
    image: '/images/services/ppf.jpg'
  },

  // Complete Packages
  {
    id: 'showroom-detail',
    name: 'Showroom Detail',
    category: 'Packages',
    price: 'Starting at $249',
    duration: '5-6 hours',
    description: 'Complete interior and exterior detailing for showroom condition.',
    features: [
      'Premium exterior wash & wax',
      'Interior deep clean',
      'Engine bay detailing',
      'Trunk detailing',
      'Paint sealant',
      'Leather/fabric protection'
    ],
    popular: true,
    image: '/images/services/showroom-detail.jpg'
  },
  {
    id: 'monthly-maintenance',
    name: 'Monthly Maintenance Plan',
    category: 'Packages',
    price: '$99/month',
    duration: 'Ongoing',
    description: 'Regular maintenance to keep your vehicle in pristine condition.',
    features: [
      'Monthly premium wash',
      'Bi-monthly interior detail',
      'Quarterly wax application',
      'Priority scheduling',
      '10% off additional services'
    ],
    popular: false,
    image: '/images/services/monthly-plan.jpg'
  }
];

export const getServicesByCategory = (category: string) => 
  services.filter(s => s.category === category);

export const getPopularServices = () => 
  services.filter(s => s.popular);

export const getServiceById = (id: string) => 
  services.find(s => s.id === id);
